package gov.va.genisis2.bo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author Getaneh Kassahun
 * 
 */

@Component
public class GetEmailProperties {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(GetEmailProperties.class);

	/** The inputStream. */
	private InputStream inputStream;

	/** The prop. */
	private Properties prop;


	public Properties getProperties() throws IOException {

		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("Get properties");
		}

		try {
			prop = new Properties();
			String propFileName = "genisisMessage.properties";

			inputStream = getClass().getClassLoader().getResourceAsStream(propFileName);

			if (inputStream != null) {
				prop.load(inputStream);
			} else {
				throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
			}
		} catch (Exception e) {
			LOGGER.error("Get properties" + e);
		} finally {
			if (inputStream != null) {
				inputStream.close();
			}
		}
		return prop;
	}


	public String getMessage(String propertiesValue, Object[] values) {

		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("Get Properties Message");
		}

		String message = null;
		Object[] mes = new Object[values.length];
		try {
			message = this.getProperties().getProperty(propertiesValue);
		} catch (IOException e) {
			LOGGER.error("Get properties Message" + e);
		}
		for (int i = 0; i < values.length; i++) {
			mes[i] = values[i];
		}

		return MessageFormat.format(message, mes);

	}
}